#include <stdio.h>
#include <stdlib.h>
#include <string>
#include <vector>
#include <map>

/*

  Copyright 2006 Charles Lohr, under MIT-X11 License.

  MODIFY THIS DOCUMENT AT LINE 250 TO REFLECT YOUR CONDITIONS.

  HPlotter - a tool to plot out .h file dependencies for files.
	This helps you find where something that you don't want is included
	
	It also helps you speed up your compile time.
  */


using namespace std;

map < string, int > HAllIncluded;
int iPlace = 1;
vector < string > IncludeFolders;
map < int, int > iSourceDrawn;
map < int, int > iSourceAlreadyDrawn;

struct HNode
{
	vector< HNode > Children;
	bool			IsSource;
	string			Self;
};

bool Plot( const string & sFileName, HNode & ret, string sRelFileName = "", string sParent = "" )
{
	char buff[4096];
	unsigned i;

	if ( HAllIncluded.find( sRelFileName ) != HAllIncluded.end() )
		ret.IsSource = false;
	else
		ret.IsSource = true;

	if ( sRelFileName.empty() )
		ret.Self = sFileName;
	else
		ret.Self = sRelFileName;

	int iThisPlace;
	
	if ( HAllIncluded[ret.Self] == 0 )
	{
		iThisPlace = iPlace;
		iPlace++;
	}
	else
		iThisPlace = HAllIncluded[ret.Self];

	if ( iSourceDrawn[HAllIncluded[sParent] * 65536 + iThisPlace] == 2 )
		return true;

	iSourceDrawn[HAllIncluded[sParent] * 65536 + iThisPlace] = 2;
	HAllIncluded[ret.Self] = iThisPlace;

	vector< string > vPathParts;
	string sRunningPath;

	i = 0; 
	while ( i < sFileName.size() )
	{
		if ( sFileName.c_str()[i] == '/' || sFileName.c_str()[i] == '\\' )
		{
			vPathParts.push_back( sRunningPath );
			sRunningPath = "";
		} else
			sRunningPath += sFileName.c_str()[i];
		i++;
	}


	FILE * f = fopen( sFileName.c_str(), "rb" );

	if ( f == NULL )
	{
		printf( "WARNING: Cannot find file %s\n", sFileName.c_str() );
		return false;
	}

	while ( !feof(f ) )
	{
		vector < string > curPath = vPathParts;

		int buffptr = 0;
		char c = 0;
		memset( buff, 0, 4096 );
		while ( !feof( f ) && c != 13 && c!= 10 )
		{
			fread( &c, 1, 1, f );
			buff[buffptr] = c;
			buffptr++;
		}

		buff[buffptr] = 0;

//		if ( fscanf( f, "%s\n", buff ) != 1 )
//			continue;
		const char * commentstart = strstr( buff, "//" );
		const char * includestart = strstr( buff, "#include" );

		if ( includestart == 0 )
			continue;

		if ( commentstart > 0 )
			if ( includestart > commentstart )
				continue;

		includestart += 8;

		while ( includestart[0] == ' ' )
			includestart++;

		const char * basestr = includestart;

		if ( includestart[0] == '\"' )
		{
			//handles ..'s first
			string sPath;
			if ( includestart[1] == ':' )
			{
				while ( includestart[0] != '\"' && includestart[0] != '\0' )
				{
					sPath += includestart[0];
					includestart++;
				}
			}
			else
			{
				while ( includestart[0] == '.' && includestart[1] == '.' )
				{
					includestart+=3;
					curPath.resize( curPath.size() - 1 );
					if ( curPath.size() == 0 )
						printf ( "Warning: %s tried to back itself too far up the tree.\n", sFileName.c_str() );
				}
				includestart++;

				for ( unsigned i = 0; i < curPath.size(); i++ )
					sPath += curPath[i] + '/';

				while ( includestart[0] != '\"' && includestart[0] != '\0' )
				{
					sPath += includestart[0];
					includestart++;
				}
			}

			HNode t;
			string sf = ((string)basestr).substr( 1, includestart-basestr-1 );//strlen( basestr ) - 3 );
			Plot( sPath, t, sf, ret.Self );
			ret.Children.push_back( t );
		} 
		else if ( includestart[0] == '<' )
		{
			string sPath;
			includestart++;
			while ( includestart[0] != '\0' && includestart[0] != '>' )
			{
				sPath += includestart[0];
				includestart++;
			}
			for ( unsigned i = 0; i < IncludeFolders.size(); i++ )
			{
				FILE * g = fopen( ( IncludeFolders[i] + sPath ).c_str(), "r" );
				if ( g ) 
				{
					fclose(g);
					HNode t;
					string sf = string( basestr ).substr( 0, includestart - basestr + 1 );
					Plot( ( IncludeFolders[i] + sPath ), t, sf, ret.Self );
					ret.Children.push_back( t );
					break;
				}
			}
			if ( i == IncludeFolders.size() )
			{
				printf( "WARNING: Cannot open file: <%s>\n", sPath.c_str() );
			}
		}
		else 
		{
			printf( "Warning: In file: %s, line %s is malformatted.\n", sFileName.c_str(), buff );
		}
	}
	fclose(f);
	return true;
}

void PrintTree( const HNode & nod, int depth = 0 )
{
	unsigned i;
	if ( nod.Self.length() > 0 )
	{
		for ( i = 0; i < depth; i++ )
			printf( " " );
		puts( nod.Self.c_str() );
	}
	for ( i = 0; i < nod.Children.size(); i++ )
		PrintTree( nod.Children[i], depth+1 );
}

void PrintTreeFile( FILE * f ,const HNode & nod, int & node, int cnode, int depth = 0 )
{
	unsigned i;

	if ( nod.Self.length() > 0 )
	{
		fprintf( f, "   Node%d [shape=\"box\",label=\"%s\",fontsize=10,height=0.2,width=0.4,fontname=\"Helvetica\",color=\"black\",style=\"filled\" fontcolor=\"white\"];\n",
			HAllIncluded[nod.Self], nod.Self.c_str() );
		if ( cnode != -1 )
		{
			if ( iSourceAlreadyDrawn[ HAllIncluded[nod.Self] * 65536 + cnode ] < 1 )
			{
				//printf( f, "%d", iSourceDrawn[cnode * 65536 + HAllIncluded[nod.Self]] );
				if ( nod.IsSource )
					fprintf( f, "   Node%d -> Node%d [dir=back,color=\"midnightblue\",fontsize=10,style=\"solid\",fontname=\"Helvetica\"];\n",
					HAllIncluded[nod.Self], cnode );
				else
				{
					fprintf( f, "   Node%d -> Node%d [dir=back,color=\"orange\",fontsize=10,style=\"solid\",fontname=\"Helvetica\"];\n",
						HAllIncluded[nod.Self], cnode );
					iSourceAlreadyDrawn[ HAllIncluded[nod.Self] * 65536 + cnode ] = 1;
				}
			}
		}
	}
	for ( i = 0; i < nod.Children.size(); i++ )
		PrintTreeFile( f, nod.Children[i], node, HAllIncluded[nod.Self], depth+1 );
}

int main( int argc, char ** argv )
{
	if ( argc != 3 )
	{
		printf( "Usage: hplotter (.h file) (.png file)\n" );
		return -1;
	}

//Include these if you want to have a graph including all system includes
//	IncludeFolders.push_back( "C:/Program Files/Microsoft Visual Studio/VC98/INCLUDE/" );
//	IncludeFolders.push_back( "C:/ode-0.5/include/" );
//	IncludeFolders.push_back( "C:/hgengine/Mercury/src/" );
//	IncludeFolders.push_back( "C:/hgengine/Mercury/src/freetype2/" );

	string sif = argv[1];
	if ( sif.c_str()[0] == '\"' )
		sif = sif.substr( 1, sif.length() - 2 );

	HNode root;
	Plot( sif, root );

	FILE * f = fopen( argv[2], "w" );
	fprintf( f, "digraph G\n{\n" );
	fprintf( f, "edge [fontname=\"Helvetica\",fontsize=10,labelfontname=\"Helvetica\",labelfontsize=10];\n" );
	fprintf( f, "node [fontname=\"Helvetica\",fontsize=10,shape=record];\n" );
	int node = 9;
	PrintTreeFile( f, root, node, -1 );
	fprintf( f, "}\n" );
	fclose( f );
	return 0;
}